{********************************************
; File: Shell.p
;
;
; Copyright Apple Computer, Inc. 1986-90
; All Rights Reserved
;
********************************************}

UNIT SHELL;
INTERFACE
USES TYPES;

TYPE
GetLInfoPBPtr = ^GetLInfoPB;
GetLInfoPB = PACKED RECORD
    sfile : Ptr; { address of source file name }
    dfile : Ptr; { address of output file name }
    parms : Ptr; { address of parameter list }
    istring : Ptr; { address of language specific input string }
    merr : Byte; { max error level allowed }
    merrf : Byte; { max error level found }
    lops : Byte; { operations flag }
    kflag : Byte; { KEEP flag }
    mflags : Longint; { set of letters selected with '-' }
    pflags : Longint; { set of letters selected with '+' }
    org : Longint; { abs start address of non-relloc load file }
END;
PROCEDURE DIRECTION ( device:Integer; direct:Ptr)  ; C;
PROCEDURE ERROR ( errorCode:Integer)  ; C;
PROCEDURE EXECUTE ( flag:Integer; comm:Ptr)  ; C;
FUNCTION  GET_LANG  : Integer ; C;
PROCEDURE GET_LINFO (VAR PblockPtr:GetLInfoPB)  ; C;
PROCEDURE GET_VAR ( varname:Ptr;VAR value:string)  ; C;
PROCEDURE INIT_WILDCARD ( initFile:Ptr; flags:Integer)  ; C;
FUNCTION  NEXT_WILDCARD ( nextFile:Ptr) : Ptr ; C;
PROCEDURE READ_INDEXED ( varname:Ptr; value:Ptr; index:Integer)  ; C;
PROCEDURE REDIRECT ( device:Integer; app:Integer; theFile:Ptr)  ; C;
PROCEDURE SET_LANG ( language:Integer)  ; C;
PROCEDURE SET_LINFO ( PblockPtr:GetLInfoPB)  ; C;
PROCEDURE SET_VAR ( varname:Ptr; value:Ptr)  ; C;
FUNCTION  STOP  : Integer ; C;
FUNCTION  VERSION  : Longint ; C;
PROCEDURE WRITE_CONSOLE ( ochar:Integer)  ; C;
IMPLEMENTATION
END.
